package com.tomas.ht_ydt;

import android.content.Intent;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.View;
import android.widget.ImageButton;
import android.widget.TextView;

import androidx.activity.EdgeToEdge;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.graphics.Insets;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;

import com.tomas.ht_ydt.lib.ActionType;
import com.tomas.ht_ydt.lib.KeyMapping;
import com.tomas.ht_ydt.lib.Settings;

public class InboundMenu_Activity extends AppCompatActivity implements View.OnClickListener{
    TextView txt_user, txt_device;
    ImageButton imb_back;
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_inbound_menu);

        txt_user = (TextView) findViewById(R.id.txt_user);
        txt_user.setText("User : "+ Settings.getLoginUser().getName());

        txt_device = (TextView) findViewById(R.id.txt_device);
        txt_device.setText("Device : "+ Settings.getDeviceNo());
        imb_back = (ImageButton)findViewById(R.id.imb_back);

    }

    @Override
    public void onClick(View view) {

    Intent intent;
        switch (view.getId()) {
            case R.id.imb_back:
                finish();
                break;
            case R.id.btn_inbound_sch:
                Settings.setActionType(String.valueOf(ActionType.Action_Type.INBOUND));
                Settings.setCMD("INBOUND/SCHEDULE");
                Settings.setMENU(String.valueOf(ActionType.Menu.INBOUND_SCHEDULE));
                intent = new Intent(InboundMenu_Activity.this, Schedule_Activity.class);
                startActivity(intent);
                break;

            case R.id.btn_inbound_manual:
                Settings.setMENU(String.valueOf(ActionType.Menu.INBOUND_MANUAL));
                Settings.setActionType(String.valueOf(ActionType.Action_Type.INBOUND));
                intent = new Intent(InboundMenu_Activity.this, InboundManual_Activity.class);
                startActivity(intent);
                break;

            case R.id.btn_inbound_rework:
                Settings.setMENU(String.valueOf(ActionType.Menu.INBOUND_REWORK));
                Settings.setActionType(String.valueOf(ActionType.Action_Type.INBOUND));
                intent = new Intent(InboundMenu_Activity.this, InboundRework_Activity.class);
                startActivity(intent);
                break;

            case R.id.btn_inbound_rework_ng:
                Settings.setMENU(String.valueOf(ActionType.Menu.INBOUND_REWORK_NG));
                intent = new Intent(InboundMenu_Activity.this, InboundRework_Activity.class);
                startActivity(intent);
                break;

        }
    }

    @Override
    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (keyCode >= KeyMapping.P1.getId()
                && keyCode <= KeyMapping.P4.getId()) {
            switch (KeyMapping.fromId(keyCode)) {
                case P1:
                    imb_back.performClick();
                    break;
            }
        }

        return super.onKeyUp(keyCode, event);
    }
}